function test_suite = testIsone %#ok<STOUT>
initTestSuite;

function testNumericOne %#ok<*DEFNU>
x = polysym(1);
assertTrue(isone(x));

function testCharOneNoPadding
x = polysym('1');
assertTrue(isone(x));

function testCharOneWithLeadingBlank
x = polysym(' 1');
assertTrue(isone(x));

function testCharOneWithTrailingBlank
x = polysym('1 ');
assertTrue(isone(x));

function testCharOneWithLeadingTab
x = polysym(sprintf('\t 1'));
assertTrue(isone(x));

function testCharOneWithTrailingTab
x = polysym(sprintf('1\t'));
assertTrue(isone(x));

function testWithDecimal
x = polysym('1.00');
assertTrue(isone(x));

function testWithExponent
x = polysym('1e0');
assertTrue(isone(x));

function testMixedDecimalExponent
x = polysym('1.00e0');
assertTrue(isone(x))